using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("severance_tax")]
[Index("StateId", "LeaseTypeId", Name = "uk_severance_tax", IsUnique = true)]
public partial class SeveranceTax
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("state_id")]
    public int StateId { get; set; }

    [Column("rate")]
    public decimal Rate { get; set; }

    [Column("regulatory_fee")]
    public decimal? RegulatoryFee { get; set; }

    [Column("lease_type_id")]
    public int LeaseTypeId { get; set; }

    [ForeignKey("LeaseTypeId")]
    [InverseProperty("SeveranceTaxes")]
    public virtual LeaseType LeaseType { get; set; } = null!;

    [ForeignKey("StateId")]
    [InverseProperty("SeveranceTaxes")]
    public virtual Territory State { get; set; } = null!;
}
