using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("security_group")]
[Index("Name", Name = "uk_security_group_name", IsUnique = true)]
public partial class SecurityGroup
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("SecurityGroup")]
    public virtual ICollection<SecurityGroupPermission> SecurityGroupPermissions { get; set; } = new List<SecurityGroupPermission>();

    [InverseProperty("SecurityGroup")]
    public virtual ICollection<SecurityUserGroup> SecurityUserGroups { get; set; } = new List<SecurityUserGroup>();
}
