using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("sales_tax")]
[Index("CountyId", Name = "uk_sales_tax", IsUnique = true)]
public partial class SalesTax
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("county_id")]
    public int CountyId { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [ForeignKey("CountyId")]
    [InverseProperty("SalesTax")]
    public virtual County County { get; set; } = null!;

    [InverseProperty("SalesTax")]
    public virtual ICollection<SalesTaxDetail> SalesTaxDetails { get; set; } = new List<SalesTaxDetail>();

    [InverseProperty("SalesTax")]
    public virtual ICollection<SalesTaxDoc> SalesTaxDocs { get; set; } = new List<SalesTaxDoc>();
}
