using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("report_filter")]
[Index("Name", "ReportId", "UserId", Name = "uk_report_filter", IsUnique = true)]
public partial class ReportFilter
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("report_id")]
    public int ReportId { get; set; }

    [Column("user_id")]
    public int UserId { get; set; }

    [Column("is_selected")]
    public bool IsSelected { get; set; }

    [ForeignKey("ReportId")]
    [InverseProperty("ReportFilters")]
    public virtual Report Report { get; set; } = null!;

    [InverseProperty("Filter")]
    public virtual ICollection<ReportFilterParameter> ReportFilterParameters { get; set; } = new List<ReportFilterParameter>();

    [ForeignKey("UserId")]
    [InverseProperty("ReportFilters")]
    public virtual AppUser User { get; set; } = null!;
}
