using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("point_source_delivery")]
[Index("DealId", Name = "ix_point_source_delivery")]
[Index("PointId", Name = "ix_point_source_delivery_1")]
[Index("DealId", "PointId", Name = "ix_point_source_delivery_deal")]
public partial class PointSourceDelivery
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("deal_id")]
    public int DealId { get; set; }

    [Column("point_id")]
    public int PointId { get; set; }

    [Column("point_volume")]
    public int? PointVolume { get; set; }

    [ForeignKey("DealId")]
    [InverseProperty("PointSourceDeliveries")]
    public virtual Deal Deal { get; set; } = null!;

    [ForeignKey("PointId")]
    [InverseProperty("PointSourceDeliveries")]
    public virtual Point Point { get; set; } = null!;
}
