using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("point_product_grade_to_index")]
public partial class PointProductGradeToIndex
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("point_id")]
    public int? PointId { get; set; }

    [Column("location_id")]
    public int? LocationId { get; set; }

    [Column("posting_index_id")]
    public int? PostingIndexId { get; set; }

    [Column("product_id")]
    public int ProductId { get; set; }

    [ForeignKey("PointId")]
    [InverseProperty("PointProductGradeToIndices")]
    public virtual Point? Point { get; set; }

    [ForeignKey("PostingIndexId")]
    [InverseProperty("PointProductGradeToIndices")]
    public virtual MarketIndex? PostingIndex { get; set; }

    [ForeignKey("ProductId")]
    [InverseProperty("PointProductGradeToIndices")]
    public virtual Product Product { get; set; } = null!;
}
