using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("plant_statement_price")]
[Index("Name", "ProductionMonth", "StatementDate", "PlantId", "ProducerId", Name = "uk_plant_statement_price", IsUnique = true)]
public partial class PlantStatementPrice
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("production_month")]
    public DateOnly ProductionMonth { get; set; }

    [Column("statement_date")]
    public DateOnly StatementDate { get; set; }

    [Column("plant_id")]
    public int PlantId { get; set; }

    [Column("producer_id")]
    public int ProducerId { get; set; }

    [Column("ethane_price")]
    public decimal? EthanePrice { get; set; }

    [Column("propane_price")]
    public decimal? PropanePrice { get; set; }

    [Column("normal_butane_price")]
    public decimal? NormalButanePrice { get; set; }

    [Column("iso_butane_price")]
    public decimal? IsoButanePrice { get; set; }

    [Column("natural_gasoline_price")]
    public decimal? NaturalGasolinePrice { get; set; }

    [Column("scrubber_price")]
    public decimal? ScrubberPrice { get; set; }

    [ForeignKey("PlantId")]
    [InverseProperty("PlantStatementPrices")]
    public virtual Plant Plant { get; set; } = null!;

    [InverseProperty("Prices")]
    public virtual ICollection<PlantStatement> PlantStatements { get; set; } = new List<PlantStatement>();

    [ForeignKey("ProducerId")]
    [InverseProperty("PlantStatementPrices")]
    public virtual Counterparty Producer { get; set; } = null!;
}
