using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("plant_statement_option")]
[Index("PlantId", "PayoutTypeId", Name = "uk_plant_statement_option", IsUnique = true)]
public partial class PlantStatementOption
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("plant_id")]
    public int PlantId { get; set; }

    [Column("payout_type_id")]
    public int? PayoutTypeId { get; set; }

    [Column("required_fields", TypeName = "citext")]
    public string? RequiredFields { get; set; }

    [ForeignKey("PayoutTypeId")]
    [InverseProperty("PlantStatementOptions")]
    public virtual PayoutType? PayoutType { get; set; }

    [ForeignKey("PlantId")]
    [InverseProperty("PlantStatementOptions")]
    public virtual Plant Plant { get; set; } = null!;
}
