using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Index("ApplicationId", "Status", "Subject", "Type", Name = "idx_26803_IX_OpenIddictTokens_ApplicationId_Status_Subject_Type")]
[Index("AuthorizationId", Name = "idx_26803_IX_OpenIddictTokens_AuthorizationId")]
public partial class OpenIddictToken
{
    [Key]
    [Column(TypeName = "citext")]
    public string Id { get; set; } = null!;

    [Column(TypeName = "citext")]
    public string? ApplicationId { get; set; }

    [Column(TypeName = "citext")]
    public string? AuthorizationId { get; set; }

    [Column(TypeName = "citext")]
    public string? ConcurrencyToken { get; set; }

    public DateTime? CreationDate { get; set; }

    public DateTime? ExpirationDate { get; set; }

    [Column(TypeName = "citext")]
    public string? Payload { get; set; }

    [Column(TypeName = "citext")]
    public string? Properties { get; set; }

    public DateTime? RedemptionDate { get; set; }

    [Column(TypeName = "citext")]
    public string? ReferenceId { get; set; }

    [Column(TypeName = "citext")]
    public string? Status { get; set; }

    [Column(TypeName = "citext")]
    public string? Subject { get; set; }

    [Column(TypeName = "citext")]
    public string? Type { get; set; }

    [ForeignKey("ApplicationId")]
    [InverseProperty("OpenIddictTokens")]
    public virtual OpenIddictApplication? Application { get; set; }

    [ForeignKey("AuthorizationId")]
    [InverseProperty("OpenIddictTokens")]
    public virtual OpenIddictAuthorization? Authorization { get; set; }
}
