using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("market_index")]
[Index("Name", Name = "uk_market_index_", IsUnique = true)]
public partial class MarketIndex
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("hybrid_index_definition", TypeName = "citext")]
    public string? HybridIndexDefinition { get; set; }

    [Column("classification_type_id")]
    public int ClassificationTypeId { get; set; }

    [Column("index_type_id")]
    public int IndexTypeId { get; set; }

    [Column("price_determination", TypeName = "citext")]
    public string? PriceDetermination { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [Column("is_future_default")]
    public bool IsFutureDefault { get; set; }

    [Column("unit_price_id")]
    public int? UnitPriceId { get; set; }

    [Column("publication_id")]
    public int? PublicationId { get; set; }

    [Column("product_id")]
    public int ProductId { get; set; }

    [Column("index_type_text", TypeName = "citext")]
    public string IndexTypeText { get; set; } = null!;

    [InverseProperty("PriceIndexId2Navigation")]
    public virtual ICollection<Deal> DealPriceIndexId2Navigations { get; set; } = new List<Deal>();

    [InverseProperty("PriceIndex")]
    public virtual ICollection<Deal> DealPriceIndices { get; set; } = new List<Deal>();

    [InverseProperty("Index")]
    public virtual ICollection<MarketIndexAlias> MarketIndexAliases { get; set; } = new List<MarketIndexAlias>();

    [InverseProperty("Index")]
    public virtual ICollection<MarketPrice> MarketPrices { get; set; } = new List<MarketPrice>();

    [InverseProperty("PostingIndex")]
    public virtual ICollection<PointProductGradeToIndex> PointProductGradeToIndices { get; set; } = new List<PointProductGradeToIndex>();

    [ForeignKey("ProductId")]
    [InverseProperty("MarketIndices")]
    public virtual Product Product { get; set; } = null!;

    [ForeignKey("PublicationId")]
    [InverseProperty("MarketIndices")]
    public virtual MarketIndexPublication? Publication { get; set; }

    [InverseProperty("InternalIndex")]
    public virtual ICollection<PublishedToInternalIndex> PublishedToInternalIndexInternalIndices { get; set; } = new List<PublishedToInternalIndex>();

    [InverseProperty("PublishedIndex")]
    public virtual PublishedToInternalIndex? PublishedToInternalIndexPublishedIndex { get; set; }

    [ForeignKey("UnitPriceId")]
    [InverseProperty("MarketIndices")]
    public virtual UnitPriceCombination? UnitPrice { get; set; }
}
