using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("holiday")]
public partial class Holiday
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("holiday_date")]
    public DateOnly? HolidayDate { get; set; }

    [Column("holiday_name", TypeName = "citext")]
    public string? HolidayName { get; set; }

    [Column("holiday_schedule_id")]
    public int HolidayScheduleId { get; set; }

    [Column("is_weekend")]
    public bool IsWeekend { get; set; }

    [ForeignKey("HolidayScheduleId")]
    [InverseProperty("Holidays")]
    public virtual HolidaySchedule HolidaySchedule { get; set; } = null!;
}
