using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("gas_invoice_snapshot")]
public partial class GasInvoiceSnapshot
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("invoice_id")]
    public int InvoiceId { get; set; }

    [Column("day")]
    public DateOnly Day { get; set; }

    [Column("receipt_deal", TypeName = "citext")]
    public string ReceiptDeal { get; set; } = null!;

    [Column("receipt_internal_entity", TypeName = "citext")]
    public string ReceiptInternalEntity { get; set; } = null!;

    [Column("receipt_counterparty", TypeName = "citext")]
    public string ReceiptCounterparty { get; set; } = null!;

    [Column("receipt_counterparty_short", TypeName = "citext")]
    public string ReceiptCounterpartyShort { get; set; } = null!;

    [Column("receipt_deal_purpose", TypeName = "citext")]
    public string ReceiptDealPurpose { get; set; } = null!;

    [Column("receipt_base_or_swing", TypeName = "citext")]
    public string ReceiptBaseOrSwing { get; set; } = null!;

    [Column("receipt_pipe", TypeName = "citext")]
    public string ReceiptPipe { get; set; } = null!;

    [Column("receipt_point", TypeName = "citext")]
    public string ReceiptPoint { get; set; } = null!;

    [Column("receipt_meter", TypeName = "citext")]
    public string ReceiptMeter { get; set; } = null!;

    [Column("receipt_pipe_contract", TypeName = "citext")]
    public string ReceiptPipeContract { get; set; } = null!;

    [Column("receipt_pipe_contract_owner", TypeName = "citext")]
    public string ReceiptPipeContractOwner { get; set; } = null!;

    [Column("receipt_nom_vol")]
    public decimal ReceiptNomVol { get; set; }

    [Column("receipt_actual_vol")]
    public decimal? ReceiptActualVol { get; set; }

    [Column("receipt_vol")]
    public decimal ReceiptVol { get; set; }

    [Column("receipt_contract_price")]
    public decimal ReceiptContractPrice { get; set; }

    [Column("receipt_pla_percentage")]
    public decimal? ReceiptPlaPercentage { get; set; }

    [Column("receipt_pla_rate")]
    public decimal? ReceiptPlaRate { get; set; }

    [Column("receipt_pla_deduct")]
    public decimal? ReceiptPlaDeduct { get; set; }

    [Column("receipt_qb_rate")]
    public decimal ReceiptQbRate { get; set; }

    [Column("receipt_qb_amount")]
    public decimal ReceiptQbAmount { get; set; }

    [Column("receipt_actual_fee")]
    public decimal ReceiptActualFee { get; set; }

    [Column("receipt_adjustment")]
    public decimal ReceiptAdjustment { get; set; }

    [Column("receipt_price_adj")]
    public decimal ReceiptPriceAdj { get; set; }

    [Column("receipt_purchase_price")]
    public decimal ReceiptPurchasePrice { get; set; }

    [Column("receipt_transport_total")]
    public decimal ReceiptTransportTotal { get; set; }

    [Column("receipt_invoice_price")]
    public decimal ReceiptInvoicePrice { get; set; }

    [Column("receipt_invoice_amount")]
    public decimal ReceiptInvoiceAmount { get; set; }

    [Column("receipt_crude_base_price")]
    public decimal ReceiptCrudeBasePrice { get; set; }

    [Column("receipt_crude_roll_price")]
    public decimal ReceiptCrudeRollPrice { get; set; }

    [Column("receipt_crude_argus_adj1")]
    public decimal ReceiptCrudeArgusAdj1 { get; set; }

    [Column("receipt_crude_argus_adj2")]
    public decimal ReceiptCrudeArgusAdj2 { get; set; }

    [Column("tne_meter", TypeName = "citext")]
    public string? TneMeter { get; set; }

    [Column("delivery_deal", TypeName = "citext")]
    public string DeliveryDeal { get; set; } = null!;

    [Column("delivery_internal_entity", TypeName = "citext")]
    public string DeliveryInternalEntity { get; set; } = null!;

    [Column("delivery_counterparty", TypeName = "citext")]
    public string DeliveryCounterparty { get; set; } = null!;

    [Column("delivery_counterparty_short", TypeName = "citext")]
    public string DeliveryCounterpartyShort { get; set; } = null!;

    [Column("delivery_deal_purpose", TypeName = "citext")]
    public string DeliveryDealPurpose { get; set; } = null!;

    [Column("delivery_base_or_swing", TypeName = "citext")]
    public string DeliveryBaseOrSwing { get; set; } = null!;

    [Column("delivery_pipe", TypeName = "citext")]
    public string DeliveryPipe { get; set; } = null!;

    [Column("delivery_point", TypeName = "citext")]
    public string DeliveryPoint { get; set; } = null!;

    [Column("delivery_meter", TypeName = "citext")]
    public string DeliveryMeter { get; set; } = null!;

    [Column("delivery_pipe_contract", TypeName = "citext")]
    public string DeliveryPipeContract { get; set; } = null!;

    [Column("delivery_pipe_contract_owner", TypeName = "citext")]
    public string DeliveryPipeContractOwner { get; set; } = null!;

    [Column("delivery_nom_vol")]
    public decimal DeliveryNomVol { get; set; }

    [Column("delivery_actual_vol")]
    public decimal? DeliveryActualVol { get; set; }

    [Column("delivery_vol")]
    public decimal DeliveryVol { get; set; }

    [Column("delivery_contract_price")]
    public decimal DeliveryContractPrice { get; set; }

    [Column("delivery_pla_percentage")]
    public decimal? DeliveryPlaPercentage { get; set; }

    [Column("delivery_pla_rate")]
    public decimal? DeliveryPlaRate { get; set; }

    [Column("delivery_pla_deduct")]
    public decimal? DeliveryPlaDeduct { get; set; }

    [Column("delivery_qb_rate")]
    public decimal DeliveryQbRate { get; set; }

    [Column("delivery_qb_amount")]
    public decimal DeliveryQbAmount { get; set; }

    [Column("delivery_actual_fee")]
    public decimal DeliveryActualFee { get; set; }

    [Column("delivery_price_adj")]
    public decimal DeliveryPriceAdj { get; set; }

    [Column("delivery_invoice_price")]
    public decimal DeliveryInvoicePrice { get; set; }

    [Column("delivery_invoice_amount")]
    public decimal DeliveryInvoiceAmount { get; set; }

    [Column("delivery_crude_base_price")]
    public decimal DeliveryCrudeBasePrice { get; set; }

    [Column("delivery_crude_roll_price")]
    public decimal DeliveryCrudeRollPrice { get; set; }

    [Column("delivery_crude_argus_adj1")]
    public decimal DeliveryCrudeArgusAdj1 { get; set; }

    [Column("delivery_crude_argus_adj2")]
    public decimal DeliveryCrudeArgusAdj2 { get; set; }

    [Column("delivery_adjustment")]
    public decimal DeliveryAdjustment { get; set; }

    [Column("non_jurisdictional")]
    public bool NonJurisdictional { get; set; }

    [Column("is_agency")]
    public bool IsAgency { get; set; }

    [Column("is_netback")]
    public bool IsNetback { get; set; }

    [Column("has_transfers")]
    public bool HasTransfers { get; set; }

    [Column("receipt_internal_contract_num", TypeName = "citext")]
    public string? ReceiptInternalContractNum { get; set; }

    [Column("receipt_counterparty_contract_num", TypeName = "citext")]
    public string? ReceiptCounterpartyContractNum { get; set; }

    [Column("delivery_internal_contract_num", TypeName = "citext")]
    public string? DeliveryInternalContractNum { get; set; }

    [Column("delivery_counterparty_contract_num", TypeName = "citext")]
    public string? DeliveryCounterpartyContractNum { get; set; }

    [Column("is_receipt_transport_overridden")]
    public bool IsReceiptTransportOverridden { get; set; }

    [Column("is_receipt_price_adj_overridden")]
    public bool IsReceiptPriceAdjOverridden { get; set; }

    [Column("is_receipt_contract_price_overridden")]
    public bool IsReceiptContractPriceOverridden { get; set; }

    [Column("is_delivery_price_adj_overridden")]
    public bool IsDeliveryPriceAdjOverridden { get; set; }

    [Column("is_delivery_actual_fee_overidden")]
    public bool IsDeliveryActualFeeOveridden { get; set; }

    [Column("is_delivery_adjustment_overridden")]
    public bool IsDeliveryAdjustmentOverridden { get; set; }

    [Column("is_receipt_adjustment_overridden")]
    public bool IsReceiptAdjustmentOverridden { get; set; }

    [Column("is_receipt_actual_fee_overridden")]
    public bool IsReceiptActualFeeOverridden { get; set; }

    [Column("is_delivery_contract_price_overridden")]
    public bool IsDeliveryContractPriceOverridden { get; set; }

    [Column("supply_nom_id")]
    public int SupplyNomId { get; set; }

    [Column("market_nom_id")]
    public int MarketNomId { get; set; }

    [Column("last_transfer_deal_id")]
    public int? LastTransferDealId { get; set; }

    [Column("receipt_deal_contract_id")]
    public int? ReceiptDealContractId { get; set; }

    [Column("delivery_deal_contract_id")]
    public int? DeliveryDealContractId { get; set; }

    [Column("receipt_deal_id")]
    public int? ReceiptDealId { get; set; }

    [Column("receipt_product_id")]
    public int? ReceiptProductId { get; set; }

    [Column("receipt_internal_entity_id")]
    public int? ReceiptInternalEntityId { get; set; }

    [Column("receipt_counterparty_id")]
    public int? ReceiptCounterpartyId { get; set; }

    [Column("receipt_transfer_deal_id")]
    public int? ReceiptTransferDealId { get; set; }

    [Column("receipt_pipe_id")]
    public int ReceiptPipeId { get; set; }

    [Column("receipt_point_id")]
    public int? ReceiptPointId { get; set; }

    [Column("receipt_meter_id")]
    public int ReceiptMeterId { get; set; }

    [Column("receipt_pipe_contract_id")]
    public int? ReceiptPipeContractId { get; set; }

    [Column("delivery_deal_id")]
    public int? DeliveryDealId { get; set; }

    [Column("delivery_product_id")]
    public int? DeliveryProductId { get; set; }

    [Column("delivery_internal_entity_id")]
    public int? DeliveryInternalEntityId { get; set; }

    [Column("delivery_counterparty_id")]
    public int? DeliveryCounterpartyId { get; set; }

    [Column("delivery_transfer_deal_id")]
    public int? DeliveryTransferDealId { get; set; }

    [Column("delivery_pipe_id")]
    public int DeliveryPipeId { get; set; }

    [Column("delivery_point_id")]
    public int? DeliveryPointId { get; set; }

    [Column("delivery_meter_id")]
    public int DeliveryMeterId { get; set; }

    [Column("tne_meter_id")]
    public int? TneMeterId { get; set; }

    [Column("delivery_pipe_contract_id")]
    public int? DeliveryPipeContractId { get; set; }

    [Column("receipt_portfolio_id")]
    public int? ReceiptPortfolioId { get; set; }

    [Column("receipt_deal_purpose_id")]
    public int? ReceiptDealPurposeId { get; set; }

    [Column("delivery_deal_purpose_id")]
    public int? DeliveryDealPurposeId { get; set; }

    [ForeignKey("InvoiceId")]
    [InverseProperty("GasInvoiceSnapshots")]
    public virtual InvoiceGa Invoice { get; set; } = null!;
}
