using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("deal")]
[Index("BuyButton", "TransactionTypeId", "StartDate", "EndDate", "Id", "PhysicalDealTypeId", "FixedPriceButton", "Volume", "VolumeTypeId", "TicketNum", "CounterpartyId", Name = "idx_26451_ix_deal_sos")]
[Index("TransactionTypeId", "InternalEntityId", "RegionId", "HypotheticalId", Name = "ix_deal_1")]
[Index("AccountingMonth", Name = "ix_deal_accounting_month")]
[Index("BuyButton", Name = "ix_deal_buy_button")]
[Index("BuyButton", "Id", "TraderId", Name = "ix_deal_buy_button_cover")]
[Index("BuyButton", "Id", "TraderId", Name = "ix_deal_buy_button_id_trader")]
[Index("CounterpartyId", Name = "ix_deal_counterparty_id")]
[Index("DealPurposeId", Name = "ix_deal_deal_purpose_id")]
[Index("EndDate", Name = "ix_deal_end_date")]
[Index("FixedPriceButton", Name = "ix_deal_fixed_price_button")]
[Index("InternalEntityId", Name = "ix_deal_internal_entity_id")]
[Index("IsPooledFutureDeal", Name = "ix_deal_is_pooled_future_deal")]
[Index("PhysicalDealTypeId", Name = "ix_deal_physical_deal_type_id")]
[Index("PhysicalLinkId", Name = "ix_deal_physical_link_id")]
[Index("PipelineId", Name = "ix_deal_pipeline_id")]
[Index("PointId", Name = "ix_deal_point_id")]
[Index("PriceIndexId", Name = "ix_deal_price_index_id")]
[Index("StartDate", Name = "ix_deal_start_date")]
[Index("StartDate", "EndDate", Name = "ix_deal_start_date_end_date")]
[Index("TicketNumber", Name = "ix_deal_ticket_number")]
[Index("TraderId", Name = "ix_deal_trader_id")]
[Index("TradingDate", Name = "ix_deal_trading_date")]
[Index("TransactionTypeId", Name = "ix_deal_transaction_type_id")]
[Index("WaspNum", Name = "ix_deal_wasp_num")]
[Index("TicketNum", Name = "uk_deal_ticket_num", IsUnique = true)]
public partial class Deal
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("accounting_month")]
    public DateOnly? AccountingMonth { get; set; }

    [Column("attach_lc_language")]
    public bool? AttachLcLanguage { get; set; }

    [Column("basis")]
    public double? Basis { get; set; }

    [Column("book_id")]
    public int? BookId { get; set; }

    [Column("broker_account_id")]
    public int? BrokerAccountId { get; set; }

    [Column("broker_id")]
    public int? BrokerId { get; set; }

    [Column("buy_button")]
    public int? BuyButton { get; set; }

    [Column("comments", TypeName = "citext")]
    public string? Comments { get; set; }

    [Column("contact_id")]
    public int? ContactId { get; set; }

    [Column("cost_basis_inc")]
    public bool? CostBasisInc { get; set; }

    [Column("cost_execution_margin")]
    public double? CostExecutionMargin { get; set; }

    [Column("cost_fuel_calculation_type_id")]
    public int? CostFuelCalculationTypeId { get; set; }

    [Column("cost_sales_margin")]
    public double? CostSalesMargin { get; set; }

    [Column("cost_nymex_execution")]
    public double? CostNymexExecution { get; set; }

    [Column("cost_prem_inc")]
    public bool? CostPremInc { get; set; }

    [Column("counterparty_id")]
    public int? CounterpartyId { get; set; }

    [Column("created")]
    public DateTime? Created { get; set; }

    [Column("created_by")]
    public int? CreatedBy { get; set; }

    [Column("deal_purpose_id")]
    public int? DealPurposeId { get; set; }

    [Column("deal_status_id")]
    public int DealStatusId { get; set; }

    [Column("delivery_mode_id")]
    public int? DeliveryModeId { get; set; }

    [Column("demand_charge", TypeName = "citext")]
    public string? DemandCharge { get; set; }

    [Column("end_date")]
    public DateOnly? EndDate { get; set; }

    [Column("fixed_price")]
    public double? FixedPrice { get; set; }

    [Column("fixed_price_button")]
    public int? FixedPriceButton { get; set; }

    [Column("fm_language", TypeName = "citext")]
    public string? FmLanguage { get; set; }

    [Column("hedge_fee")]
    public double? HedgeFee { get; set; }

    [Column("hypothetical_id")]
    public int HypotheticalId { get; set; }

    [Column("internal_entity_id")]
    public int? InternalEntityId { get; set; }

    [Column("internal_memo", TypeName = "citext")]
    public string? InternalMemo { get; set; }

    [Column("is_pooled_future_deal")]
    public int IsPooledFutureDeal { get; set; }

    [Column("is_variable_volume")]
    public bool IsVariableVolume { get; set; }

    [Column("modified")]
    public DateTime? Modified { get; set; }

    [Column("modified_by")]
    public int? ModifiedBy { get; set; }

    [Column("netting_contract_number", TypeName = "citext")]
    public string? NettingContractNumber { get; set; }

    [Column("num_of_contracts")]
    public int? NumOfContracts { get; set; }

    [Column("physical_deal_type_id")]
    public int? PhysicalDealTypeId { get; set; }

    [Column("physical_link_id")]
    public int? PhysicalLinkId { get; set; }

    [Column("pipeline_id")]
    public int? PipelineId { get; set; }

    [Column("pipeline_source_delivery_id")]
    public int? PipelineSourceDeliveryId { get; set; }

    [Column("point_id")]
    public int? PointId { get; set; }

    [Column("portfolio_id")]
    public int? PortfolioId { get; set; }

    [Column("premium_or_discount")]
    public double? PremiumOrDiscount { get; set; }

    [Column("price_index_id")]
    public int? PriceIndexId { get; set; }

    [Column("price_index_id_sign")]
    public int? PriceIndexIdSign { get; set; }

    [Column("price_index_id2")]
    public int? PriceIndexId2 { get; set; }

    [Column("price_index_id2_sign")]
    public int? PriceIndexId2Sign { get; set; }

    [Column("region_id")]
    public int? RegionId { get; set; }

    [Column("settle_type_id")]
    public int? SettleTypeId { get; set; }

    [Column("start_date")]
    public DateOnly? StartDate { get; set; }

    [Column("strategy_id")]
    public int? StrategyId { get; set; }

    [Column("tax_credit")]
    public double? TaxCredit { get; set; }

    [Column("ticket_num", TypeName = "citext")]
    public string TicketNum { get; set; } = null!;

    [Column("tn_e_expense", TypeName = "citext")]
    public string? TnEExpense { get; set; }

    [Column("tn_e_fuel_percent", TypeName = "citext")]
    public string? TnEFuelPercent { get; set; }

    [Column("trader_id")]
    public int? TraderId { get; set; }

    [Column("trading_date")]
    public DateOnly? TradingDate { get; set; }

    [Column("transaction_type_id")]
    public int? TransactionTypeId { get; set; }

    [Column("unit_basis_price_id")]
    public int? UnitBasisPriceId { get; set; }

    [Column("unit_fixed_price_id")]
    public int? UnitFixedPriceId { get; set; }

    [Column("unit_of_measure_id")]
    public int? UnitOfMeasureId { get; set; }

    [Column("unit_prem_disc_price_id")]
    public int? UnitPremDiscPriceId { get; set; }

    [Column("unit_tax_credit_id")]
    public int? UnitTaxCreditId { get; set; }

    [Column("update_notes", TypeName = "citext")]
    public string? UpdateNotes { get; set; }

    [Column("volume")]
    public double? Volume { get; set; }

    [Column("volume_type_id")]
    public int VolumeTypeId { get; set; }

    [Column("wasp_num", TypeName = "citext")]
    public string? WaspNum { get; set; }

    [Column("product_id")]
    public int ProductId { get; set; }

    [Column("volume_c2")]
    public decimal? VolumeC2 { get; set; }

    [Column("volume_c3")]
    public decimal? VolumeC3 { get; set; }

    [Column("volume_ic4")]
    public decimal? VolumeIc4 { get; set; }

    [Column("volume_nc4")]
    public decimal? VolumeNc4 { get; set; }

    [Column("volume_c5_p")]
    public decimal? VolumeC5P { get; set; }

    [Column("fixed_price_c2")]
    public decimal? FixedPriceC2 { get; set; }

    [Column("basis_c2")]
    public decimal? BasisC2 { get; set; }

    [Column("price_index_id_c2")]
    public int? PriceIndexIdC2 { get; set; }

    [Column("prem_disc_c2")]
    public decimal? PremDiscC2 { get; set; }

    [Column("fixed_price_c3")]
    public decimal? FixedPriceC3 { get; set; }

    [Column("basis_c3")]
    public decimal? BasisC3 { get; set; }

    [Column("price_index_id_c3")]
    public int? PriceIndexIdC3 { get; set; }

    [Column("prem_disc_c3")]
    public decimal? PremDiscC3 { get; set; }

    [Column("fixed_price_ic4")]
    public decimal? FixedPriceIc4 { get; set; }

    [Column("basis_ic4")]
    public decimal? BasisIc4 { get; set; }

    [Column("price_index_id_ic4")]
    public int? PriceIndexIdIc4 { get; set; }

    [Column("prem_disc_ic4")]
    public decimal? PremDiscIc4 { get; set; }

    [Column("fixed_price_nc4")]
    public decimal? FixedPriceNc4 { get; set; }

    [Column("basis_nc4")]
    public decimal? BasisNc4 { get; set; }

    [Column("price_index_id_nc4")]
    public int? PriceIndexIdNc4 { get; set; }

    [Column("prem_disc_nc4")]
    public decimal? PremDiscNc4 { get; set; }

    [Column("fixed_price_c5_p")]
    public decimal? FixedPriceC5P { get; set; }

    [Column("basis_c5_p")]
    public decimal? BasisC5P { get; set; }

    [Column("price_index_id_c5_p")]
    public int? PriceIndexIdC5P { get; set; }

    [Column("prem_disc_c5_p")]
    public decimal? PremDiscC5P { get; set; }

    [Column("in_spec_marketing_fee")]
    public decimal? InSpecMarketingFee { get; set; }

    [Column("in_spec_marketing_fee_type_id")]
    public int? InSpecMarketingFeeTypeId { get; set; }

    [Column("out_spec_marketing_fee")]
    public decimal? OutSpecMarketingFee { get; set; }

    [Column("out_spec_marketing_fee_type_id")]
    public int? OutSpecMarketingFeeTypeId { get; set; }

    [Column("superior_fee")]
    public decimal? SuperiorFee { get; set; }

    [Column("superior_fee_type_id")]
    public int? SuperiorFeeTypeId { get; set; }

    [Column("paid_on_id")]
    public int? PaidOnId { get; set; }

    [Column("is_netback")]
    public bool IsNetback { get; set; }

    [Column("ticket_number")]
    public int TicketNumber { get; set; }

    [Column("deduct_transport")]
    public bool DeductTransport { get; set; }

    [ForeignKey("BookId")]
    [InverseProperty("Deals")]
    public virtual Book? Book { get; set; }

    [ForeignKey("BrokerId")]
    [InverseProperty("Deals")]
    public virtual Broker? Broker { get; set; }

    [ForeignKey("BrokerAccountId")]
    [InverseProperty("Deals")]
    public virtual BrokerAccount? BrokerAccount { get; set; }

    [ForeignKey("BuyButton")]
    [InverseProperty("Deals")]
    public virtual BuySellType? BuyButtonNavigation { get; set; }

    [ForeignKey("ContactId")]
    [InverseProperty("Deals")]
    public virtual Contact? Contact { get; set; }

    [ForeignKey("CostFuelCalculationTypeId")]
    [InverseProperty("Deals")]
    public virtual FuelCalculationType? CostFuelCalculationType { get; set; }

    [ForeignKey("CounterpartyId")]
    [InverseProperty("DealCounterparties")]
    public virtual Counterparty? Counterparty { get; set; }

    [ForeignKey("CreatedBy")]
    [InverseProperty("DealCreatedByNavigations")]
    public virtual AppUser? CreatedByNavigation { get; set; }

    [InverseProperty("Deal")]
    public virtual ICollection<CrudeMarket> CrudeMarkets { get; set; } = new List<CrudeMarket>();

    [InverseProperty("Deal")]
    public virtual ICollection<CrudeSupply> CrudeSupplies { get; set; } = new List<CrudeSupply>();

    [InverseProperty("TicketNumNavigation")]
    public virtual DealConfirmation? DealConfirmation { get; set; }

    [ForeignKey("DealPurposeId")]
    [InverseProperty("Deals")]
    public virtual DealPurposeType? DealPurpose { get; set; }

    [ForeignKey("DealStatusId")]
    [InverseProperty("Deals")]
    public virtual DealStatus DealStatus { get; set; } = null!;

    [InverseProperty("Deal")]
    public virtual ICollection<DealVolume> DealVolumes { get; set; } = new List<DealVolume>();

    [ForeignKey("DeliveryModeId")]
    [InverseProperty("Deals")]
    public virtual DeliveryMode? DeliveryMode { get; set; }

    [InverseProperty("Deal")]
    public virtual ICollection<GasMarket> GasMarkets { get; set; } = new List<GasMarket>();

    [InverseProperty("Deal")]
    public virtual ICollection<GasSupply> GasSupplies { get; set; } = new List<GasSupply>();

    [ForeignKey("HypotheticalId")]
    [InverseProperty("Deals")]
    public virtual HypotheticalType Hypothetical { get; set; } = null!;

    [ForeignKey("InternalEntityId")]
    [InverseProperty("DealInternalEntities")]
    public virtual Counterparty? InternalEntity { get; set; }

    [InverseProperty("PhysicalLink")]
    public virtual ICollection<Deal> InversePhysicalLink { get; set; } = new List<Deal>();

    [InverseProperty("Deal")]
    public virtual ICollection<InvoiceCrudeLine> InvoiceCrudeLines { get; set; } = new List<InvoiceCrudeLine>();

    [InverseProperty("Deal")]
    public virtual ICollection<InvoiceGasLine> InvoiceGasLines { get; set; } = new List<InvoiceGasLine>();

    [ForeignKey("ModifiedBy")]
    [InverseProperty("DealModifiedByNavigations")]
    public virtual AppUser? ModifiedByNavigation { get; set; }

    [ForeignKey("PhysicalDealTypeId")]
    [InverseProperty("Deals")]
    public virtual PhysicalDealType? PhysicalDealType { get; set; }

    [ForeignKey("PhysicalLinkId")]
    [InverseProperty("InversePhysicalLink")]
    public virtual Deal? PhysicalLink { get; set; }

    [ForeignKey("PipelineId")]
    [InverseProperty("DealPipelines")]
    public virtual Pipeline? Pipeline { get; set; }

    [ForeignKey("PipelineSourceDeliveryId")]
    [InverseProperty("DealPipelineSourceDeliveries")]
    public virtual Pipeline? PipelineSourceDelivery { get; set; }

    [ForeignKey("PointId")]
    [InverseProperty("Deals")]
    public virtual Point? Point { get; set; }

    [InverseProperty("Deal")]
    public virtual ICollection<PointSourceDelivery> PointSourceDeliveries { get; set; } = new List<PointSourceDelivery>();

    [ForeignKey("PortfolioId")]
    [InverseProperty("Deals")]
    public virtual Portfolio? Portfolio { get; set; }

    [ForeignKey("PriceIndexId")]
    [InverseProperty("DealPriceIndices")]
    public virtual MarketIndex? PriceIndex { get; set; }

    [ForeignKey("PriceIndexId2")]
    [InverseProperty("DealPriceIndexId2Navigations")]
    public virtual MarketIndex? PriceIndexId2Navigation { get; set; }

    [ForeignKey("ProductId")]
    [InverseProperty("Deals")]
    public virtual Product Product { get; set; } = null!;

    [ForeignKey("RegionId")]
    [InverseProperty("Deals")]
    public virtual Region? Region { get; set; }

    [ForeignKey("SettleTypeId")]
    [InverseProperty("Deals")]
    public virtual SettleType? SettleType { get; set; }

    [InverseProperty("SupplyDeal")]
    public virtual ICollection<SosHiddenDeal> SosHiddenDeals { get; set; } = new List<SosHiddenDeal>();

    [ForeignKey("StrategyId")]
    [InverseProperty("Deals")]
    public virtual Strategy? Strategy { get; set; }

    [ForeignKey("TraderId")]
    [InverseProperty("DealTraders")]
    public virtual AppUser? Trader { get; set; }

    [ForeignKey("TransactionTypeId")]
    [InverseProperty("Deals")]
    public virtual TransactionType? TransactionType { get; set; }

    [ForeignKey("UnitBasisPriceId")]
    [InverseProperty("DealUnitBasisPrices")]
    public virtual UnitPriceCombination? UnitBasisPrice { get; set; }

    [ForeignKey("UnitFixedPriceId")]
    [InverseProperty("DealUnitFixedPrices")]
    public virtual UnitPriceCombination? UnitFixedPrice { get; set; }

    [ForeignKey("UnitOfMeasureId")]
    [InverseProperty("Deals")]
    public virtual UnitOfMeasure? UnitOfMeasure { get; set; }

    [ForeignKey("UnitPremDiscPriceId")]
    [InverseProperty("DealUnitPremDiscPrices")]
    public virtual UnitPriceCombination? UnitPremDiscPrice { get; set; }

    [ForeignKey("UnitTaxCreditId")]
    [InverseProperty("DealUnitTaxCredits")]
    public virtual UnitPriceCombination? UnitTaxCredit { get; set; }

    [ForeignKey("VolumeTypeId")]
    [InverseProperty("Deals")]
    public virtual VolumeType VolumeType { get; set; } = null!;
}
