using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("crude_path")]
[Index("Name", "IsPathByMeter", Name = "uk_crude_path", IsUnique = true)]
public partial class CrudePath
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("is_path_by_meter")]
    public bool IsPathByMeter { get; set; }

    [Column("source_counterparty_id")]
    public int? SourceCounterpartyId { get; set; }

    [Column("source_meter_id")]
    public int SourceMeterId { get; set; }

    [Column("source_pipe_contract_id")]
    public int? SourcePipeContractId { get; set; }

    [InverseProperty("Path")]
    public virtual ICollection<CrudePathRoute> CrudePathRoutes { get; set; } = new List<CrudePathRoute>();

    [ForeignKey("SourceCounterpartyId")]
    [InverseProperty("CrudePaths")]
    public virtual Counterparty? SourceCounterparty { get; set; }

    [ForeignKey("SourceMeterId")]
    [InverseProperty("CrudePaths")]
    public virtual Meter SourceMeter { get; set; } = null!;

    [ForeignKey("SourcePipeContractId")]
    [InverseProperty("CrudePaths")]
    public virtual PipelineContract? SourcePipeContract { get; set; }

    [InverseProperty("CrudePath")]
    public virtual ICollection<TransferDeal> TransferDeals { get; set; } = new List<TransferDeal>();
}
