using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("crude_market")]
[Index("Date", Name = "ix_crude_market_date")]
[Index("DealId", "Month", Name = "ix_crude_market_deal_id_month")]
[Index("MeterId", Name = "ix_crude_market_meter_id")]
[Index("Month", Name = "ix_crude_market_month")]
[Index("TransferDealId", Name = "ix_crude_market_transfer_deal_id")]
[Index("DealId", "Date", "TransferDealId", "PointId", Name = "uk_crude_market", IsUnique = true)]
public partial class CrudeMarket
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("deal_id")]
    public int? DealId { get; set; }

    [Column("transfer_deal_id")]
    public int? TransferDealId { get; set; }

    [Column("meter_id")]
    public int MeterId { get; set; }

    [Column("point_id")]
    public int? PointId { get; set; }

    [Column("rank")]
    public int Rank { get; set; }

    [Column("date")]
    public DateOnly Date { get; set; }

    [Column("month")]
    public DateOnly Month { get; set; }

    [InverseProperty("MarketNom")]
    public virtual ICollection<CrudeActual> CrudeActuals { get; set; } = new List<CrudeActual>();

    [InverseProperty("MarketNom")]
    public virtual ICollection<CrudeMarketSupply> CrudeMarketSupplies { get; set; } = new List<CrudeMarketSupply>();

    [ForeignKey("DealId")]
    [InverseProperty("CrudeMarkets")]
    public virtual Deal? Deal { get; set; }

    [ForeignKey("MeterId")]
    [InverseProperty("CrudeMarkets")]
    public virtual Meter Meter { get; set; } = null!;

    [ForeignKey("PointId")]
    [InverseProperty("CrudeMarkets")]
    public virtual Point? Point { get; set; }

    [ForeignKey("TransferDealId")]
    [InverseProperty("CrudeMarkets")]
    public virtual TransferDeal? TransferDeal { get; set; }
}
