using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("counterparty_product")]
[Index("CounterpartyId", "ProductId", Name = "uk_counterparty_product", IsUnique = true)]
public partial class CounterpartyProduct
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("counterparty_id")]
    public int CounterpartyId { get; set; }

    [Column("product_id")]
    public int ProductId { get; set; }

    [ForeignKey("CounterpartyId")]
    [InverseProperty("CounterpartyProducts")]
    public virtual Counterparty Counterparty { get; set; } = null!;

    [ForeignKey("ProductId")]
    [InverseProperty("CounterpartyProducts")]
    public virtual Product Product { get; set; } = null!;
}
