using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("contract_payment_type")]
public partial class ContractPaymentType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("is_wire")]
    public bool IsWire { get; set; }

    [InverseProperty("PayFromBank")]
    public virtual ICollection<Contract> ContractPayFromBanks { get; set; } = new List<Contract>();

    [InverseProperty("PayToBank")]
    public virtual ICollection<Contract> ContractPayToBanks { get; set; } = new List<Contract>();

    [InverseProperty("ContractPaymentType")]
    public virtual ICollection<InvoiceCrude> InvoiceCrudes { get; set; } = new List<InvoiceCrude>();

    [InverseProperty("ContractPaymentType")]
    public virtual ICollection<InvoiceGa> InvoiceGas { get; set; } = new List<InvoiceGa>();
}
