using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("contract_contact")]
[Index("ContractId", Name = "uk_contract_contact_contract", IsUnique = true)]
public partial class ContractContact
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("contract_id")]
    public int ContractId { get; set; }

    [Column("commercial_address_line1", TypeName = "citext")]
    public string? CommercialAddressLine1 { get; set; }

    [Column("commercial_address_line2", TypeName = "citext")]
    public string? CommercialAddressLine2 { get; set; }

    [Column("commercial_city", TypeName = "citext")]
    public string? CommercialCity { get; set; }

    [Column("commercial_zip", TypeName = "citext")]
    public string? CommercialZip { get; set; }

    [Column("commercial_attn", TypeName = "citext")]
    public string? CommercialAttn { get; set; }

    [Column("commercial_telephone_num", TypeName = "citext")]
    public string? CommercialTelephoneNum { get; set; }

    [Column("commercial_fax_num", TypeName = "citext")]
    public string? CommercialFaxNum { get; set; }

    [Column("commercial_email_address", TypeName = "citext")]
    public string? CommercialEmailAddress { get; set; }

    [Column("scheduling_address_line1", TypeName = "citext")]
    public string? SchedulingAddressLine1 { get; set; }

    [Column("scheduling_address_line2", TypeName = "citext")]
    public string? SchedulingAddressLine2 { get; set; }

    [Column("scheduling_city", TypeName = "citext")]
    public string? SchedulingCity { get; set; }

    [Column("scheduling_zip", TypeName = "citext")]
    public string? SchedulingZip { get; set; }

    [Column("scheduling_attn", TypeName = "citext")]
    public string? SchedulingAttn { get; set; }

    [Column("scheduling_telephone_num", TypeName = "citext")]
    public string? SchedulingTelephoneNum { get; set; }

    [Column("scheduling_fax_num", TypeName = "citext")]
    public string? SchedulingFaxNum { get; set; }

    [Column("scheduling_email_address", TypeName = "citext")]
    public string? SchedulingEmailAddress { get; set; }

    [Column("notices_address_line1", TypeName = "citext")]
    public string? NoticesAddressLine1 { get; set; }

    [Column("notices_address_line2", TypeName = "citext")]
    public string? NoticesAddressLine2 { get; set; }

    [Column("notices_city", TypeName = "citext")]
    public string? NoticesCity { get; set; }

    [Column("notices_zip", TypeName = "citext")]
    public string? NoticesZip { get; set; }

    [Column("notices_attn", TypeName = "citext")]
    public string? NoticesAttn { get; set; }

    [Column("notices_telephone_num", TypeName = "citext")]
    public string? NoticesTelephoneNum { get; set; }

    [Column("notices_fax_num", TypeName = "citext")]
    public string? NoticesFaxNum { get; set; }

    [Column("notices_email_address", TypeName = "citext")]
    public string? NoticesEmailAddress { get; set; }

    [Column("credit_address_line1", TypeName = "citext")]
    public string? CreditAddressLine1 { get; set; }

    [Column("credit_address_line2", TypeName = "citext")]
    public string? CreditAddressLine2 { get; set; }

    [Column("credit_city", TypeName = "citext")]
    public string? CreditCity { get; set; }

    [Column("credit_zip", TypeName = "citext")]
    public string? CreditZip { get; set; }

    [Column("credit_attn", TypeName = "citext")]
    public string? CreditAttn { get; set; }

    [Column("credit_telephone_num", TypeName = "citext")]
    public string? CreditTelephoneNum { get; set; }

    [Column("credit_fax_num", TypeName = "citext")]
    public string? CreditFaxNum { get; set; }

    [Column("credit_email_address", TypeName = "citext")]
    public string? CreditEmailAddress { get; set; }

    [Column("confirmations_address_line1", TypeName = "citext")]
    public string? ConfirmationsAddressLine1 { get; set; }

    [Column("confirmations_address_line2", TypeName = "citext")]
    public string? ConfirmationsAddressLine2 { get; set; }

    [Column("confirmations_city", TypeName = "citext")]
    public string? ConfirmationsCity { get; set; }

    [Column("confirmations_zip", TypeName = "citext")]
    public string? ConfirmationsZip { get; set; }

    [Column("confirmations_attn", TypeName = "citext")]
    public string? ConfirmationsAttn { get; set; }

    [Column("confirmations_telephone_num", TypeName = "citext")]
    public string? ConfirmationsTelephoneNum { get; set; }

    [Column("confirmations_fax_num", TypeName = "citext")]
    public string? ConfirmationsFaxNum { get; set; }

    [Column("confirmations_email_address", TypeName = "citext")]
    public string? ConfirmationsEmailAddress { get; set; }

    [Column("do_email")]
    public bool DoEmail { get; set; }

    [Column("do_fax")]
    public bool DoFax { get; set; }

    [Column("combine_email")]
    public bool CombineEmail { get; set; }

    [Column("commercial_country_id")]
    public int CommercialCountryId { get; set; }

    [Column("scheduling_country_id")]
    public int SchedulingCountryId { get; set; }

    [Column("notices_country_id")]
    public int NoticesCountryId { get; set; }

    [Column("credit_country_id")]
    public int CreditCountryId { get; set; }

    [Column("confirmations_country_id")]
    public int ConfirmationsCountryId { get; set; }

    [Column("commercial_state_id")]
    public int? CommercialStateId { get; set; }

    [Column("scheduling_state_id")]
    public int? SchedulingStateId { get; set; }

    [Column("notices_state_id")]
    public int? NoticesStateId { get; set; }

    [Column("credit_state_id")]
    public int? CreditStateId { get; set; }

    [Column("confirmations_state_id")]
    public int? ConfirmationsStateId { get; set; }

    [ForeignKey("CommercialCountryId")]
    [InverseProperty("ContractContactCommercialCountries")]
    public virtual Country CommercialCountry { get; set; } = null!;

    [ForeignKey("CommercialStateId")]
    [InverseProperty("ContractContactCommercialStates")]
    public virtual Territory? CommercialState { get; set; }

    [ForeignKey("ConfirmationsCountryId")]
    [InverseProperty("ContractContactConfirmationsCountries")]
    public virtual Country ConfirmationsCountry { get; set; } = null!;

    [ForeignKey("ConfirmationsStateId")]
    [InverseProperty("ContractContactConfirmationsStates")]
    public virtual Territory? ConfirmationsState { get; set; }

    [ForeignKey("ContractId")]
    [InverseProperty("ContractContact")]
    public virtual Contract Contract { get; set; } = null!;

    [ForeignKey("CreditCountryId")]
    [InverseProperty("ContractContactCreditCountries")]
    public virtual Country CreditCountry { get; set; } = null!;

    [ForeignKey("CreditStateId")]
    [InverseProperty("ContractContactCreditStates")]
    public virtual Territory? CreditState { get; set; }

    [ForeignKey("NoticesCountryId")]
    [InverseProperty("ContractContactNoticesCountries")]
    public virtual Country NoticesCountry { get; set; } = null!;

    [ForeignKey("NoticesStateId")]
    [InverseProperty("ContractContactNoticesStates")]
    public virtual Territory? NoticesState { get; set; }

    [ForeignKey("SchedulingCountryId")]
    [InverseProperty("ContractContactSchedulingCountries")]
    public virtual Country SchedulingCountry { get; set; } = null!;

    [ForeignKey("SchedulingStateId")]
    [InverseProperty("ContractContactSchedulingStates")]
    public virtual Territory? SchedulingState { get; set; }
}
