using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("business_sub_type")]
[Index("Name", "BusinessTypeId", Name = "uk_business_sub_type", IsUnique = true)]
public partial class BusinessSubType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("business_type_id")]
    public int BusinessTypeId { get; set; }

    [ForeignKey("BusinessTypeId")]
    [InverseProperty("BusinessSubTypes")]
    public virtual BusinessType BusinessType { get; set; } = null!;

    [InverseProperty("BusinessSubType")]
    public virtual ICollection<Counterparty> Counterparties { get; set; } = new List<Counterparty>();
}
