using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[PrimaryKey("UserId", "LoginProvider", "Name")]
[Table("asp_user_token")]
public partial class AspUserToken
{
    [Key]
    public int UserId { get; set; }

    [Key]
    [Column(TypeName = "citext")]
    public string LoginProvider { get; set; } = null!;

    [Key]
    [Column(TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column(TypeName = "citext")]
    public string? Value { get; set; }

    [ForeignKey("UserId")]
    [InverseProperty("AspUserTokens")]
    public virtual AppUser User { get; set; } = null!;
}
