using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("asp_role")]
public partial class AspRole
{
    [Key]
    public int Id { get; set; }

    [Column(TypeName = "citext")]
    public string? Name { get; set; }

    [Column(TypeName = "citext")]
    public string? NormalizedName { get; set; }

    [Column(TypeName = "citext")]
    public string? ConcurrencyStamp { get; set; }

    [InverseProperty("Role")]
    public virtual ICollection<AspRoleClaim> AspRoleClaims { get; set; } = new List<AspRoleClaim>();

    [ForeignKey("RoleId")]
    [InverseProperty("Roles")]
    public virtual ICollection<AppUser> Users { get; set; } = new List<AppUser>();
}
