# Determine the operating system
$os = $PSVersionTable.OS

if ($os -match "Windows") {
  # Run the Windows (not pwsh core) PowerShell script
  Write-Host "Running on Windows. Executing AfterPublish.ps1..."
  Start-Process -FilePath 'powershell.exe' -ArgumentList "-NoProfile -ExecutionPolicy RemoteSigned -NoExit -Command & '$PSScriptRoot/AfterPublish.ps1'"
}
else {
  # Run the Bash script
  Write-Host "Running on Linux/Mac. Executing AfterPublish.zsh..."
  #2>&1 | Write-Host #redirects standard error (2) to standard output (1)
  zsh -c "$PSScriptRoot/AfterPublish.zsh" 2>&1 | Write-Host
}
